@echo off
setlocal enabledelayedexpansion

:: Prompt user for the keyword to find
set /p findStr="Enter the keyword to replace: "
:: Prompt user for the replacement keyword
set /p replaceStr="Enter the replacement keyword: "

:: Loop through all .mcfunction and .json files in subdirectories
for /r %%f in (*.mcfunction *.json) do (
    echo Processing "%%f"
    powershell -Command "(Get-Content -Raw '%%f') -replace '%findStr%', '%replaceStr%' | Set-Content '%%f'"
)

:: Rename folders if they contain the keyword
for /d /r %%d in (*) do (
    set "folderName=%%~nxd"
    set "folderPath=%%~fd"
    echo !folderName! | findstr /i "%findStr%" >nul && (
        set "newFolderName=!folderName:%findStr%=%replaceStr%!"
        if not "!folderName!"=="!newFolderName!" (
            echo Renaming "%%d" to "!newFolderName!"
            ren "%%d" "!newFolderName!" 2>nul || echo Failed to rename "%%d"
        )
    )
)



echo Replacement complete.
pause